/*
	    Script per il MODELLO CERTIFICAZIONE UNICA 2021 - NORMATIVA 2020:
		  - aggiunge un campo per il codice dello stato estero di residenza fino al rientro o trasferimento in Italia per docenti, ricercatori e impatriati
		  - aggiunge un campo importo necessario per l'indicazione delle somme restituite al netto della ritenuita subita
*/
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG3U_CODICE_CG07')
	BEGIN
		ALTER TABLE CG3U_CERTUNICA
			ADD CG3U_CODICE_CG07		DECIMAL(4)	NULL

			CREATE INDEX IDX01_CG07_CG3U ON CG3U_CERTUNICA
			(
				CG3U_CODICE_CG07		ASC
			)

			ALTER TABLE CG3U_CERTUNICA
			      ADD CONSTRAINT FK_CG07_CG3U
                      FOREIGN KEY (CG3U_CODICE_CG07)
                              REFERENCES CG07_TABSTATIEST  (CG07_CODICE)

		PRINT 'Tabella CG3U_CERTUNICA : campo CG3U_CODICE_CG07 creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG3U_CERTUNICA : campo CG3U_CODICE_CG07 esistente, creazione non effettuata'
	END		
GO
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG3U_SOMRESTNETRIT')
	BEGIN
		ALTER TABLE CG3U_CERTUNICA
			ADD CG3U_SOMRESTNETRIT		DECIMAL(13,2)	NULL
		PRINT 'Tabella CG3U_CERTUNICA : campo CG3U_SOMRESTNETRIT creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG3U_CERTUNICA : campo CG3U_SOMRESTNETRIT esistente, creazione non effettuata'
	END		
GO
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
